#!/bin/bash
export datasets1="Cora CiteSeer PubMed OGBN-Arxiv"
export datasets2="OGBN-Arxiv"
export missing_rates="0.99 0.999 0.9999 1.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=3

# structural
# for dataset in $datasets1
# do
# for missing_rate in $missing_rates
# do
# python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --embedder TWIRLS --filling_method zero --n_runs 10 --gpu ${gpu}
# python main.py --dataset ${dataset} --missing_type structural --missing_rate ${missing_rate} --embedder TWIRLS --filling_method zero --n_runs 10 --gpu ${gpu}
# done
# done

# for dataset in $datasets1
# do
# for missing_rate in $missing_rates
# do
# python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --embedder GNN --gnn GAT --filling_method zero --n_runs 10 --gpu ${gpu}
# python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --embedder GNN --gnn GAT --filling_method neighborhood_mean --n_runs 10 --gpu ${gpu}
# python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --embedder GNN --gnn GAT --filling_method fp --n_runs 10 --gpu ${gpu}
# done
# done

for dataset in $datasets1
do
for missing_rate in $missing_rates
do
python main.py --dataset ${dataset} --missing_type structural --missing_rate ${missing_rate} --embedder GNN --gnn GAT --filling_method zero --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type structural --missing_rate ${missing_rate} --embedder GNN --gnn GAT --filling_method neighborhood_mean --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type structural --missing_rate ${missing_rate} --embedder GNN --gnn GAT --filling_method fp --n_runs 10 --gpu ${gpu}
done
done

for dataset in $datasets2
do
for missing_rate in $missing_rates
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --embedder TWIRLS --filling_method zero --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type structural --missing_rate ${missing_rate} --embedder TWIRLS --filling_method zero --n_runs 10 --gpu ${gpu}
done
done
